/*
 * Decompiled with CFR 0.152.
 */
package Output;

import Display.LanguageManager;
import Display.StatusBar;
import Tree.BinaryOperator;
import Tree.Function;
import Tree.Grouping;
import Tree.MathObject;
import Tree.Matrix;
import Tree.NaryFunction;
import Tree.NaryOperator;
import Tree.Precedence;
import Tree.RealNumber;
import Tree.Text;
import Tree.Variable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class OutputFormat {
    private String output = "";
    private boolean autoBrackets;
    private Document formatDoc;
    private Element root;
    private Element bracket;
    private SAXBuilder builder;
    private String outputFormat;
    private URL appletCodeBase;
    private StatusBar status;
    private LanguageManager langMan;

    public OutputFormat(StatusBar status, LanguageManager langMan, URL appletCodeBase) {
        this.status = status;
        this.autoBrackets = false;
        this.builder = new SAXBuilder();
        this.appletCodeBase = appletCodeBase;
        this.langMan = langMan;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String outputToClipboard(MathObject startNode) {
        this.autoBrackets = false;
        String syntax = "";
        try {
            this.root = this.formatDoc.getRootElement();
            this.bracket = this.root.getChild("BracketsRnd");
            if (startNode != null) {
                Element initial = this.root.getChild("Initial");
                this.output = this.output + initial.getChild("output1").getText();
                if (this.root.getChild("name").getAttributeValue("AutoBrackets").equals("true")) {
                    this.autoBrackets = true;
                }
                this.convert(startNode);
                this.output = this.output + initial.getChild("output2").getText();
                JTextField temp = new JTextField(this.output);
                syntax = this.output;
                temp.selectAll();
                temp.copy();
                this.output = "";
                this.status.println(this.langMan.readLangFile("Clipboard"));
            } else {
                this.status.println(this.langMan.readLangFile("NoExpression"));
            }
        }
        catch (NullPointerException err) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile"), "DragMath", 0);
        }
        return syntax;
    }

    public void readFormatFile(String fileName) {
        try {
            URL path = new URL(this.appletCodeBase + "formats/" + fileName + ".xml");
            this.formatDoc = this.builder.build(path);
            this.outputFormat = fileName;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile2") + " " + fileName, "DragMath", 0);
        }
        catch (JDOMException ex) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile2") + " " + fileName, "DragMath", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile2") + " " + fileName, "DragMath", 0);
        }
    }

    public void readMathTranFile() {
        try {
            this.formatDoc = this.builder.build(this.getClass().getResourceAsStream("MathTran.xml"));
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile2") + "MathTran", "DragMath", 0);
        }
        catch (JDOMException ex) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile2") + "MathTran", "DragMath", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, this.langMan.readLangFile("ReadingFile2") + "MathTran", "DragMath", 0);
        }
    }

    public void convert(MathObject start) throws NullPointerException {
        block69: {
            int x;
            int i;
            if (start.getClass().getName().equals("Tree.Text")) {
                Text textObj = (Text)start;
                Element text = this.root.getChild("Text");
                try {
                    this.output = this.output + text.getChild("initial").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
                this.output = this.output + text.getChild("output1").getText() + textObj.getText() + text.getChild("output2").getText();
            }
            if (start.getClass().getName().equals("Tree.RealNumber")) {
                RealNumber numberObj = (RealNumber)start;
                Element number = this.root.getChild("RealNumber");
                try {
                    this.output = this.output + number.getChild("initial").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
                this.output = this.output + number.getChild("output1").getText() + numberObj.getNumber() + number.getChild("output2").getText();
            }
            if (start.getClass().getName().equals("Tree.Variable")) {
                Element var;
                Variable variableObj = (Variable)start;
                try {
                    var = this.root.getChild(String.valueOf(variableObj.getVarName()));
                    this.output = this.output + var.getChild("output").getText();
                }
                catch (NullPointerException err) {
                    var = this.root.getChild(String.valueOf(variableObj.getName()));
                    if (variableObj.getName() == "Variable") {
                        this.output = this.output + var.getChild("output1").getText();
                        this.output = this.output + variableObj.getVarName();
                        this.output = this.output + var.getChild("output2").getText();
                    }
                    this.output = this.output + var.getChild("output").getText();
                }
            }
            if (start.getClass().getName().equals("Tree.BinaryOperator")) {
                BinaryOperator binaryObj = (BinaryOperator)start;
                Element binary = this.root.getChild(binaryObj.getName());
                try {
                    this.output = this.output + binary.getChild("initial").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
                boolean brackets = false;
                if (this.autoBrackets) {
                    try {
                        if (binary.getAttributeValue("brackets").equals("true")) {
                            brackets = true;
                        }
                    }
                    catch (NullPointerException err) {
                        brackets = true;
                    }
                }
                if (brackets) {
                    brackets = false;
                    if (binaryObj.getParent() != null && Precedence.value[binaryObj.getID()] <= Precedence.value[binaryObj.getParent().getID()]) {
                        brackets = true;
                    }
                }
                if (brackets) {
                    this.output = this.output + this.bracket.getChild("output1").getText();
                }
                this.output = this.output + binary.getChild("output1").getText();
                try {
                    if (binary.getAttributeValue("reverse").equals("true")) {
                        this.convert(binaryObj.getRightChild());
                    } else {
                        this.convert(binaryObj.getLeftChild());
                    }
                }
                catch (NullPointerException ex) {
                    this.convert(binaryObj.getLeftChild());
                }
                this.output = this.output + binary.getChild("output2").getText();
                try {
                    if (binary.getAttributeValue("reverse").equals("true")) {
                        this.convert(binaryObj.getLeftChild());
                    } else {
                        this.convert(binaryObj.getRightChild());
                    }
                }
                catch (NullPointerException ex) {
                    this.convert(binaryObj.getRightChild());
                }
                this.output = this.output + binary.getChild("output3").getText();
                if (brackets) {
                    this.output = this.output + this.bracket.getChild("output2").getText();
                }
            }
            if (start.getClass().getName().equals("Tree.Function")) {
                Function functionObj = (Function)start;
                Element function = this.root.getChild(functionObj.getName());
                try {
                    this.output = this.output + function.getChild("initial").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
                this.output = this.output + function.getChild("output1").getText();
                try {
                    if (function.getAttributeValue("brackets").equals("true")) {
                        this.output = this.output + this.bracket.getChild("output1").getText();
                    }
                }
                catch (NullPointerException err) {
                    this.output = this.output + this.bracket.getChild("output1").getText();
                }
                this.convert(functionObj.getChild());
                this.output = this.output + function.getChild("output2").getText();
                try {
                    if (function.getAttributeValue("brackets").equals("true")) {
                        this.output = this.output + this.bracket.getChild("output2").getText();
                    }
                }
                catch (NullPointerException err) {
                    this.output = this.output + this.bracket.getChild("output2").getText();
                }
            }
            if (start.getClass().getName().equals("Tree.Matrix")) {
                Matrix matrixObj = (Matrix)start;
                Element matrix = this.root.getChild(matrixObj.getName());
                int matrix_m = matrixObj.getM();
                int matrix_n = matrixObj.getN();
                this.output = this.output + matrix.getChild("matrixStart").getText();
                int x2 = 0;
                for (int y = 0; y < matrix_m; ++y) {
                    this.output = this.output + matrix.getChild("rowStart").getText();
                    while (x2 < matrix_n) {
                        this.output = this.output + matrix.getChild("elementStart").getText();
                        this.convert(matrixObj.getElement(y, x2));
                        this.output = this.output + matrix.getChild("elementEnd").getText();
                        if (x2 != matrix_n - 1) {
                            this.output = this.output + matrix.getChild("elementSeparator").getText();
                        }
                        ++x2;
                    }
                    this.output = this.output + matrix.getChild("rowEnd").getText();
                    if (y != matrix_m - 1) {
                        this.output = this.output + matrix.getChild("rowSeparator").getText();
                    }
                    x2 = 0;
                }
                this.output = this.output + matrix.getChild("matrixEnd").getText();
            }
            if (start.getClass().getName().equals("Tree.Grouping")) {
                Grouping groupingObj = (Grouping)start;
                Element grouping = this.root.getChild(groupingObj.getName());
                try {
                    this.output = this.output + grouping.getChild("initial").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
                this.output = this.output + grouping.getChild("output1").getText();
                this.convert(groupingObj.getChild());
                this.output = this.output + grouping.getChild("output2").getText();
            }
            if (start.getClass().getName().equals("Tree.NaryOperator")) {
                int i2;
                NaryOperator naryObj = (NaryOperator)start;
                Element nary = this.root.getChild(naryObj.getName());
                try {
                    this.output = this.output + nary.getChild("initial").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
                boolean brackets = false;
                if (this.autoBrackets) {
                    try {
                        if (nary.getAttributeValue("brackets").equals("true")) {
                            brackets = true;
                        }
                    }
                    catch (NullPointerException err) {
                        brackets = true;
                    }
                }
                if (brackets) {
                    brackets = false;
                    if (naryObj.getParent() != null && Precedence.value[naryObj.getID()] <= Precedence.value[naryObj.getParent().getID()]) {
                        brackets = true;
                    }
                }
                if (brackets) {
                    this.output = this.output + this.bracket.getChild("output1").getText();
                }
                for (i2 = naryObj.getSize() - 1; i2 >= 1; --i2) {
                    this.convert(naryObj.getChild(i2));
                    this.output = this.output + nary.getChild("output").getText();
                }
                this.convert(naryObj.getChild(i2));
                if (brackets) {
                    this.output = this.output + this.bracket.getChild("output2").getText();
                }
                try {
                    this.output = this.output + nary.getChild("final").getText();
                }
                catch (NullPointerException err) {
                    // empty catch block
                }
            }
            if (!start.getClass().getName().equals("Tree.NaryFunction")) break block69;
            NaryFunction naryFunctionObj = (NaryFunction)start;
            Element naryFunction = this.root.getChild(naryFunctionObj.getName());
            try {
                this.output = this.output + naryFunction.getChild("initial").getText();
            }
            catch (NullPointerException err) {
                // empty catch block
            }
            this.output = this.output + naryFunction.getChild("output1").getText();
            String[] orders = null;
            String order = null;
            try {
                order = naryFunction.getAttributeValue("order");
                if (order != null) {
                    orders = order.split(",");
                }
            }
            catch (NullPointerException err) {
                // empty catch block
            }
            if (order != null) {
                for (i = 0; i < naryFunctionObj.getSize(); ++i) {
                    this.convert(naryFunctionObj.getChild(Integer.parseInt(orders[i])));
                    x = i + 2;
                    this.output = this.output + naryFunction.getChild("output" + String.valueOf(x)).getText();
                }
            } else {
                while (i < naryFunctionObj.getSize()) {
                    this.convert(naryFunctionObj.getChild(i));
                    x = i + 2;
                    this.output = this.output + naryFunction.getChild("output" + String.valueOf(x)).getText();
                    ++i;
                }
            }
        }
    }
}

