/*
 * Decompiled with CFR 0.152.
 */
package Tree;

import Display.AddComponent;
import Display.LanguageManager;
import Tree.BinaryOperator;
import Tree.Function;
import Tree.Grouping;
import Tree.MathObject;
import Tree.Matrix;
import Tree.NaryFunction;
import Tree.NaryOperator;
import Tree.Precedence;
import Tree.RealNumber;
import Tree.Text;
import Tree.Variable;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdom.Element;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.VariableFactory;
import org.nfunk.jep.function.DefiniteIntegral;
import org.nfunk.jep.function.Determinant;
import org.nfunk.jep.function.Differential;
import org.nfunk.jep.function.Integral;
import org.nfunk.jep.function.Intersection;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Product;
import org.nfunk.jep.function.Subset;
import org.nfunk.jep.function.Sum;
import org.nfunk.jep.function.Trace;
import org.nfunk.jep.function.Union;

public class BuildTree {
    private static Element inpComps;
    private int copyStart;
    private int copyFinish;
    private JPanel copyLayer;
    private boolean copy;
    private LanguageManager langMan;

    public BuildTree(LanguageManager langMan, Element inpComps) {
        this.langMan = langMan;
        BuildTree.inpComps = inpComps;
    }

    public MathObject generateTree(JPanel layer, boolean copy, int copyStart, int copyFinish) throws java.text.ParseException {
        MathObject tree;
        Stack outputStack;
        this.copy = copy;
        if (copy) {
            this.copyStart = copyStart;
            this.copyFinish = copyFinish;
            this.copyLayer = layer;
        }
        if (!(outputStack = this.toPostfix(layer, new Stack(), new Stack())).empty()) {
            tree = (MathObject)outputStack.pop();
            BuildTree.toTree(tree, outputStack);
        } else {
            tree = null;
        }
        return tree;
    }

    public Stack toPostfix(Container layer, Stack operatorStack, Stack outStack) throws java.text.ParseException {
        int lastAdded = 0;
        Component[] components = layer.getComponents();
        int i = 0;
        int x = components.length;
        if (x > 0) {
            if (this.copy && layer == this.copyLayer) {
                i = this.copyStart;
                x = this.copyFinish + 1;
            }
            while (i < x) {
                if (components[i].getClass().getName().equals("Display.TextBox")) {
                    JTextField temp = (JTextField)components[i];
                    if (lastAdded == 2) {
                        throw new java.text.ParseException(this.langMan.readLangFile("Operator") + i, i);
                    }
                    try {
                        Stack textBoxStack = BuildTree.parseString(temp.getText(), new Stack());
                        for (int j = 0; j < textBoxStack.size(); ++j) {
                            outStack.push(textBoxStack.get(j));
                        }
                    }
                    catch (ParseException ex) {
                        outStack.push(new Text(temp.getText()));
                    }
                    lastAdded = 2;
                } else if (components[i].getClass().getName().equals("javax.swing.JLabel")) {
                    if (lastAdded != 2) {
                        throw new java.text.ParseException(this.langMan.readLangFile("Argument") + i, i);
                    }
                    lastAdded = 1;
                    int ID = AddComponent.getID(components[i].getName());
                    int group = AddComponent.getGroup(components[i].getName());
                    String name = AddComponent.getName(components[i].getName());
                    MathObject temp = null;
                    if (!operatorStack.empty()) {
                        temp = (MathObject)operatorStack.peek();
                    }
                    while (!operatorStack.empty() && Precedence.value[ID] <= Precedence.value[temp.getID()]) {
                        outStack.push(operatorStack.pop());
                        if (operatorStack.empty()) continue;
                        temp = (MathObject)operatorStack.peek();
                    }
                    if (group == 1) {
                        operatorStack.push(new NaryOperator(ID, name));
                    } else {
                        operatorStack.push(new BinaryOperator(ID, name));
                    }
                } else if (components[i].getClass().getName().equals("javax.swing.JPanel")) {
                    if (components[i].getName() != "") {
                        int ID = AddComponent.getID(components[i].getName());
                        int group = AddComponent.getGroup(components[i].getName());
                        String name = AddComponent.getName(components[i].getName());
                        lastAdded = 2;
                        if (group == 3) {
                            Container functionLayer = (Container)components[i];
                            Component[] functionComponents = functionLayer.getComponents();
                            Stack functionOutStack = this.toPostfix((Container)functionComponents[2], new Stack(), new Stack());
                            outStack.push(functionOutStack);
                            outStack.push(new Function(ID, name));
                        }
                        if (group == 5) {
                            Container groupLayer = (Container)components[i];
                            Component[] groupComponents = groupLayer.getComponents();
                            Stack groupOutStack = this.toPostfix((Container)groupComponents[1], new Stack(), new Stack());
                            outStack.push(groupOutStack);
                            outStack.push(new Grouping(ID, name));
                        }
                        if (group == 0) {
                            Stack layoutOutStack2;
                            Stack layoutOutStack1;
                            Stack layoutOutStack22;
                            Stack layoutOutStack3;
                            Stack layoutOutStack12;
                            Stack layoutOutStack23;
                            JPanel temp;
                            Container layoutLayer = (Container)components[i];
                            Component[] layoutComponents = layoutLayer.getComponents();
                            if (ID == 9) {
                                JPanel matrix = (JPanel)layoutComponents[1];
                                GridLayout layout = (GridLayout)matrix.getLayout();
                                Component[] matrixElements = matrix.getComponents();
                                for (int j = 0; j < matrixElements.length; ++j) {
                                    outStack.push(this.toPostfix((Container)matrixElements[j], new Stack(), new Stack()));
                                }
                                outStack.push(new Matrix(ID, name, layout.getRows(), layout.getColumns()));
                            }
                            int first = -1;
                            int second = -1;
                            if (ID == 1) {
                                first = 1;
                                second = 2;
                            }
                            if (ID == 50) {
                                first = 3;
                                second = 0;
                            }
                            if (ID == 6) {
                                first = 2;
                                second = 3;
                            }
                            if (ID == 7 || ID == 8) {
                                first = 1;
                                second = 0;
                            }
                            if (ID == 29 || ID == 37) {
                                first = 1;
                            }
                            if (ID == 5) {
                                first = 2;
                            }
                            if (ID == 57) {
                                temp = (JPanel)layoutComponents[1];
                                Stack layoutOutStack32 = this.toPostfix((Container)temp.getComponent(2), new Stack(), new Stack());
                                outStack.push(layoutOutStack32);
                                layoutOutStack23 = this.toPostfix((Container)temp.getComponent(0), new Stack(), new Stack());
                                outStack.push(layoutOutStack23);
                                layoutOutStack12 = this.toPostfix((Container)layoutComponents[2], new Stack(), new Stack());
                                outStack.push(layoutOutStack12);
                                outStack.push(new NaryFunction(ID, name, 3));
                            }
                            if (ID == 56) {
                                temp = (JPanel)layoutComponents[0];
                                temp = (JPanel)temp.getComponent(1);
                                Stack layoutOutStack33 = this.toPostfix((Container)temp.getComponent(2), new Stack(), new Stack());
                                outStack.push(layoutOutStack33);
                                layoutOutStack23 = this.toPostfix((Container)temp.getComponent(0), new Stack(), new Stack());
                                outStack.push(layoutOutStack23);
                                layoutOutStack12 = this.toPostfix((Container)layoutComponents[1], new Stack(), new Stack());
                                outStack.push(layoutOutStack12);
                                outStack.push(new NaryFunction(ID, name, 3));
                            }
                            if (ID == 53) {
                                temp = (JPanel)layoutComponents[0];
                                Stack layoutOutStack4 = this.toPostfix((Container)temp.getComponent(0), new Stack(), new Stack());
                                outStack.push(layoutOutStack4);
                                layoutOutStack3 = this.toPostfix((Container)temp.getComponent(2), new Stack(), new Stack());
                                outStack.push(layoutOutStack3);
                                layoutOutStack22 = this.toPostfix((Container)layoutComponents[2], new Stack(), new Stack());
                                outStack.push(layoutOutStack22);
                                layoutOutStack1 = this.toPostfix((Container)layoutComponents[3], new Stack(), new Stack());
                                outStack.push(layoutOutStack1);
                                outStack.push(new NaryFunction(ID, name, 4));
                            }
                            if (ID == 54 || ID == 55) {
                                temp = (JPanel)layoutComponents[0];
                                Stack layoutOutStack4 = this.toPostfix((Container)temp.getComponent(0), new Stack(), new Stack());
                                outStack.push(layoutOutStack4);
                                temp = (JPanel)temp.getComponent(2);
                                layoutOutStack3 = this.toPostfix((Container)temp.getComponent(2), new Stack(), new Stack());
                                outStack.push(layoutOutStack3);
                                layoutOutStack22 = this.toPostfix((Container)temp.getComponent(0), new Stack(), new Stack());
                                outStack.push(layoutOutStack22);
                                layoutOutStack1 = this.toPostfix((Container)layoutComponents[1], new Stack(), new Stack());
                                outStack.push(layoutOutStack1);
                                outStack.push(new NaryFunction(ID, name, 4));
                            }
                            if (ID == 46 || ID == 84) {
                                temp = (JPanel)layoutComponents[0];
                                JPanel temp2 = (JPanel)temp.getComponent(2);
                                layoutOutStack23 = this.toPostfix((Container)temp2.getComponent(1), new Stack(), new Stack());
                                outStack.push(layoutOutStack23);
                                layoutOutStack12 = this.toPostfix((Container)layoutComponents[1], new Stack(), new Stack());
                                outStack.push(layoutOutStack12);
                                outStack.push(new NaryFunction(ID, name, 2));
                            }
                            if (ID == 45) {
                                layoutOutStack2 = this.toPostfix((Container)layoutComponents[2], new Stack(), new Stack());
                                outStack.push(layoutOutStack2);
                                Stack layoutOutStack13 = this.toPostfix((Container)layoutComponents[3], new Stack(), new Stack());
                                outStack.push(layoutOutStack13);
                                outStack.push(new NaryFunction(ID, name, 2));
                            }
                            if (second != -1) {
                                layoutOutStack2 = this.toPostfix((Container)layoutComponents[first], new Stack(), new Stack());
                                outStack.push(layoutOutStack2);
                                Stack layoutOutStack14 = this.toPostfix((Container)layoutComponents[second], new Stack(), new Stack());
                                outStack.push(layoutOutStack14);
                                outStack.push(new BinaryOperator(ID, name));
                            } else if (first != -1) {
                                Stack layoutOutStack = this.toPostfix((Container)layoutComponents[first], new Stack(), new Stack());
                                outStack.push(layoutOutStack);
                                outStack.push(new Function(ID, name));
                            }
                        }
                    } else {
                        JPanel temp = (JPanel)components[i];
                        components = temp.getComponents();
                        i = -1;
                        x = components.length;
                    }
                }
                ++i;
            }
            if (lastAdded != 2) {
                throw new java.text.ParseException(this.langMan.readLangFile("Argument") + i, i);
            }
            while (!operatorStack.empty()) {
                outStack.push(operatorStack.pop());
            }
        }
        return outStack;
    }

    public static Stack parseString(String expression, Stack outputStack) throws ParseException {
        if (expression.equals("")) {
            outputStack.add(new Text(expression));
        } else {
            expression = BuildTree.validateBeforeParsing(expression);
            JEP parser = new JEP();
            parser.addStandardFunctions();
            parser.setAllowUndeclared(true);
            parser.setImplicitMul(true);
            parser.addFunction("union", (PostfixMathCommandI)new Union());
            parser.addFunction("intersection", (PostfixMathCommandI)new Intersection());
            parser.addFunction("det", (PostfixMathCommandI)new Determinant());
            parser.addFunction("trace", (PostfixMathCommandI)new Trace());
            parser.addFunction("subsetp", (PostfixMathCommandI)new Subset());
            parser.addFunction("integrate", (PostfixMathCommandI)new Integral());
            parser.addFunction("diff", (PostfixMathCommandI)new Differential());
            parser.addFunction("sum", (PostfixMathCommandI)new Sum());
            parser.addFunction("product", (PostfixMathCommandI)new Product());
            parser.addFunction("int", (PostfixMathCommandI)new DefiniteIntegral());
            parser.parseExpression(expression);
            Node node = parser.getTopNode();
            if (node == null) {
                throw new ParseException();
            }
            outputStack = BuildTree.convertJEPTree(node, new Stack(), expression);
        }
        return outputStack;
    }

    public static String validateBeforeParsing(String theText) {
        int i;
        for (i = 0; i < theText.length(); ++i) {
            char ascii_value = theText.charAt(i);
            if (ascii_value <= '\u007f' || i >= theText.length() - 1) continue;
            char nextChar = theText.charAt(i + 1);
            if (!Character.isLetterOrDigit(theText.charAt(i + 1)) && nextChar <= '\u007f') continue;
            String left = theText.substring(0, i + 1);
            String right = theText.substring(i + 1, theText.length());
            theText = left + "*" + right;
        }
        for (i = 0; i < theText.length(); ++i) {
            char token = theText.charAt(i);
            char infinity = '\u221e';
            if (token == '=') {
                theText = theText.substring(0, i + 1) + "=" + theText.substring(i + 1, theText.length());
                ++i;
            }
            if (token != infinity) continue;
            theText = theText.substring(0, i) + '\u03ac' + theText.substring(i + 1, theText.length());
        }
        return theText;
    }

    public static Stack convertJEPTree(Node currentNode, Stack outputStack, String expression) {
        if (currentNode.getClass().getName().equals("org.nfunk.jep.ASTFunNode")) {
            ASTVarNode newChild;
            VariableFactory varFactory;
            ASTFunNode funNode = (ASTFunNode)currentNode;
            String name = funNode.getPFMC().getClass().getName();
            int i = name.lastIndexOf(".");
            String type = name.substring(i + 1);
            Element comp = null;
            if (type.equals("Integral")) {
                if (funNode.jjtGetNumChildren() >= 4) {
                    type = "DefiniteIntegral";
                }
                if (funNode.jjtGetNumChildren() == 1) {
                    varFactory = new VariableFactory();
                    newChild = new ASTVarNode(0);
                    newChild.setVar(varFactory.createVariable("x"));
                    funNode.jjtAddChild((Node)newChild, 1);
                }
            }
            if (type.equals("DefiniteIntegral")) {
                if (funNode.jjtGetNumChildren() == 1) {
                    varFactory = new VariableFactory();
                    newChild = new ASTVarNode(0);
                    newChild.setVar(varFactory.createVariable("x"));
                    funNode.jjtAddChild((Node)newChild, 1);
                }
                if (funNode.jjtGetNumChildren() == 2 || funNode.jjtGetNumChildren() == 3) {
                    type = "Integral";
                }
            }
            if ((comp = inpComps.getChild(type)) != null) {
                int group = Integer.parseInt(comp.getAttributeValue("group"));
                if (group == 1) {
                    BuildTree.convertJEPTree(funNode.jjtGetChild(0), outputStack, expression);
                    BuildTree.convertJEPTree(funNode.jjtGetChild(1), outputStack, expression);
                    outputStack.push(new NaryOperator(Integer.parseInt(comp.getAttributeValue("ID")), type));
                }
                if (group == 2) {
                    BuildTree.convertJEPTree(funNode.jjtGetChild(0), outputStack, expression);
                    BuildTree.convertJEPTree(funNode.jjtGetChild(1), outputStack, expression);
                    outputStack.push(new BinaryOperator(Integer.parseInt(comp.getAttributeValue("ID")), type));
                }
                if (group == 3) {
                    Stack functionStack = BuildTree.convertJEPTree(funNode.jjtGetChild(0), new Stack(), expression);
                    outputStack.push(functionStack);
                    outputStack.push(new Function(Integer.parseInt(comp.getAttributeValue("ID")), type));
                }
                if (group == 5) {
                    Stack groupingStack = BuildTree.convertJEPTree(funNode.jjtGetChild(0), new Stack(), expression);
                    outputStack.push(groupingStack);
                    outputStack.push(new Grouping(Integer.parseInt(comp.getAttributeValue("ID")), type));
                }
                if (group == 0) {
                    if (funNode.isOperator()) {
                        BuildTree.convertJEPTree(funNode.jjtGetChild(0), outputStack, expression);
                        BuildTree.convertJEPTree(funNode.jjtGetChild(1), outputStack, expression);
                        outputStack.push(new BinaryOperator(Integer.parseInt(comp.getAttributeValue("ID")), type));
                    } else {
                        for (int j = funNode.jjtGetNumChildren() - 1; j >= 0; --j) {
                            Stack functionStack = BuildTree.convertJEPTree(funNode.jjtGetChild(j), new Stack(), expression);
                            outputStack.push(functionStack);
                        }
                        if (funNode.jjtGetNumChildren() > 1) {
                            outputStack.push(new NaryFunction(Integer.parseInt(comp.getAttributeValue("ID")), type, funNode.jjtGetNumChildren()));
                        } else {
                            outputStack.push(new Function(Integer.parseInt(comp.getAttributeValue("ID")), type));
                        }
                    }
                }
            } else {
                if (type.equals("Comparative")) {
                    if (funNode.getName().equals("<")) {
                        type = "LessThan";
                    } else if (funNode.getName().equals(">")) {
                        type = "MoreThan";
                    } else if (funNode.getName().equals("<=")) {
                        type = "LTEQ";
                    } else if (funNode.getName().equals(">=")) {
                        type = "GTEQ";
                    } else if (funNode.getName().equals("!=")) {
                        type = "NotEqual";
                    } else if (funNode.getName().equals("==")) {
                        type = "Equals";
                    }
                    comp = inpComps.getChild(type);
                }
                try {
                    BuildTree.convertJEPTree(funNode.jjtGetChild(0), outputStack, expression);
                    BuildTree.convertJEPTree(funNode.jjtGetChild(1), outputStack, expression);
                    outputStack.push(new BinaryOperator(Integer.parseInt(comp.getAttributeValue("ID")), type));
                }
                catch (NullPointerException ex) {
                    outputStack.add(new Text(expression));
                }
            }
        }
        if (currentNode.getClass().getName().equals("org.nfunk.jep.ASTConstant")) {
            ASTConstant constantNode = (ASTConstant)currentNode;
            double d = Double.parseDouble(constantNode.getValue().toString());
            int x = (int)d;
            outputStack.push(new RealNumber(x));
        }
        if (currentNode.getClass().getName().equals("org.nfunk.jep.ASTVarNode")) {
            ASTVarNode varNode = (ASTVarNode)currentNode;
            if (varNode.getName().length() > 1) {
                outputStack.push(new Text(varNode.getName()));
            } else if (varNode.getName().charAt(0) == '\u03ac') {
                outputStack.push(new Variable('\u221e', "Variable"));
            } else {
                outputStack.push(new Variable(varNode.getName().charAt(0), "Variable"));
            }
        }
        return outputStack;
    }

    public static void toTree(MathObject currentNode, Stack currentStack) {
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                if (currentStack.empty()) break block9;
                                if (!currentNode.getClass().getName().equals("Tree.NaryFunction")) break block10;
                                NaryFunction naryFunctionObj = (NaryFunction)currentNode;
                                for (int i = 0; i < naryFunctionObj.getSize(); ++i) {
                                    Stack stack = (Stack)currentStack.pop();
                                    MathObject child1 = (MathObject)stack.pop();
                                    naryFunctionObj.setChild(child1, i);
                                    naryFunctionObj.getChild(i).setParent(naryFunctionObj);
                                    BuildTree.toTree(child1, stack);
                                }
                                break block9;
                            }
                            if (!currentNode.getClass().getName().equals("Tree.BinaryOperator")) break block11;
                            BinaryOperator binaryObj = (BinaryOperator)currentNode;
                            if (binaryObj.getID() == 1 || binaryObj.getID() == 6 || binaryObj.getID() == 7 || binaryObj.getID() == 8 || binaryObj.getID() == 45 || binaryObj.getID() == 46 || binaryObj.getID() == 50 || binaryObj.getID() == 84) {
                                Object obj = currentStack.pop();
                                if (obj.getClass().getName() != "java.util.Stack") {
                                    binaryObj.setRightChild((MathObject)obj);
                                    binaryObj.getRightChild().setParent(binaryObj);
                                    BuildTree.toTree(binaryObj.getRightChild(), currentStack);
                                    binaryObj.setLeftChild((MathObject)currentStack.pop());
                                    binaryObj.getLeftChild().setParent(binaryObj);
                                    BuildTree.toTree(binaryObj.getLeftChild(), currentStack);
                                } else {
                                    Stack leftStack = (Stack)obj;
                                    Stack rightStack = (Stack)currentStack.pop();
                                    MathObject leftChild = (MathObject)leftStack.pop();
                                    binaryObj.setLeftChild(leftChild);
                                    binaryObj.getLeftChild().setParent(binaryObj);
                                    BuildTree.toTree(leftChild, leftStack);
                                    MathObject rightChild = (MathObject)rightStack.pop();
                                    binaryObj.setRightChild(rightChild);
                                    binaryObj.getRightChild().setParent(binaryObj);
                                    BuildTree.toTree(rightChild, rightStack);
                                }
                            } else {
                                binaryObj.setRightChild((MathObject)currentStack.pop());
                                binaryObj.getRightChild().setParent(binaryObj);
                                BuildTree.toTree(binaryObj.getRightChild(), currentStack);
                                binaryObj.setLeftChild((MathObject)currentStack.pop());
                                binaryObj.getLeftChild().setParent(binaryObj);
                                BuildTree.toTree(binaryObj.getLeftChild(), currentStack);
                            }
                            break block9;
                        }
                        if (!currentNode.getClass().getName().equals("Tree.NaryOperator")) break block12;
                        NaryOperator naryObj = (NaryOperator)currentNode;
                        int i = -1;
                        MathObject nextObject = (MathObject)currentStack.peek();
                        while (nextObject.getID() == naryObj.getID()) {
                            currentStack.remove(currentStack.size() - 1);
                            naryObj.addChild((MathObject)currentStack.pop(), ++i);
                            naryObj.getChild(i).setParent(naryObj);
                            BuildTree.toTree(naryObj.getChild(i), currentStack);
                            nextObject = (MathObject)currentStack.peek();
                        }
                        naryObj.addChild((MathObject)currentStack.pop(), ++i);
                        naryObj.getChild(i).setParent(naryObj);
                        BuildTree.toTree(naryObj.getChild(i), currentStack);
                        nextObject = (MathObject)currentStack.peek();
                        while (nextObject.getID() == naryObj.getID()) {
                            currentStack.remove(currentStack.size() - 1);
                            naryObj.addChild((MathObject)currentStack.pop(), ++i);
                            naryObj.getChild(i).setParent(naryObj);
                            BuildTree.toTree(naryObj.getChild(i), currentStack);
                            nextObject = (MathObject)currentStack.peek();
                        }
                        naryObj.addChild((MathObject)currentStack.pop(), ++i);
                        naryObj.getChild(i).setParent(naryObj);
                        BuildTree.toTree(naryObj.getChild(i), currentStack);
                        break block9;
                    }
                    if (!currentNode.getClass().getName().equals("Tree.Function")) break block13;
                    Function functionObj = (Function)currentNode;
                    Stack functionStack = (Stack)currentStack.pop();
                    MathObject root = (MathObject)functionStack.pop();
                    BuildTree.toTree(root, functionStack);
                    functionObj.setChild(root);
                    break block9;
                }
                if (!currentNode.getClass().getName().equals("Tree.Grouping")) break block14;
                Grouping groupingObj = (Grouping)currentNode;
                Stack groupingStack = (Stack)currentStack.pop();
                MathObject root = (MathObject)groupingStack.pop();
                BuildTree.toTree(root, groupingStack);
                groupingObj.setChild(root);
                break block9;
            }
            if (!currentNode.getClass().getName().equals("Tree.Matrix")) break block9;
            Matrix matrixObj = (Matrix)currentNode;
            int m = matrixObj.getM();
            int n = matrixObj.getN();
            int j = n - 1;
            for (int i = m - 1; i >= 0; --i) {
                while (j >= 0) {
                    Stack matrixStack = (Stack)currentStack.pop();
                    MathObject element = (MathObject)matrixStack.pop();
                    matrixObj.setElement(i, j, element);
                    matrixObj.getElement(i, j).setParent(matrixObj);
                    BuildTree.toTree(element, matrixStack);
                    --j;
                }
                j = n - 1;
            }
        }
    }

    public int getCopyFinish() {
        return this.copyFinish;
    }
}

